FILESEXTRAPATHS_prepend := "${THISDIR}/${PN}:"
S = "${WORKDIR}/git"
SRC_URI += "git://git@github.com/rdk-gdcs/apparmor-profiles.git;protocol=ssh;nobranch=1;destsuffix=git/apparmor-profiles;name=apparmor-profiles"
SRC_URI +=  "git://github.com/rdkcentral/rdk-apparmor-profiles;protocol=https;nobranch=1;destsuffix=git/rdk-apparmor-profiles;name=rdk-apparmor-profiles"
SRCREV_apparmor-profiles = "7a2a739cf8998edf3665d7c2962350ea2c43bb94"
SRCREV_rdk-apparmor-profiles = "1072ee15e3b3a59097e732f8b56a87ca04cb52ed"
SRCREV_FORMAT = "apparmor-profiles_rdk-apparmor-profiles"
PACKAGE_BEFORE_PN += "${PN}-optimized"
SYSTEMD_SERVICE_${PN} = "apparmor.service"

DEPENDS += "virtual/kernel"
do_configure[depends] += "virtual/kernel:do_shared_workdir"

do_parse_kernel_config() {
    # Failing the build if apparmor Kernel config is not present
    if ! grep -q "CONFIG_SECURITY_APPARMOR=y" "${STAGING_KERNEL_BUILDDIR}/.config" || ! grep -q "CONFIG_SECURITY=y" "${STAGING_KERNEL_BUILDDIR}/.config"; then
        bbfatal "Apparmor is not enabled in kernel configuration, aborting build"
    fi
}
addtask do_parse_kernel_config after do_configure before do_compile

do_install_append () {
    install -d ${D}${sysconfdir}/apparmor/caps
    install -d ${D}${sysconfdir}/apparmor/unconfined
    install -d ${D}${sysconfdir}/apparmor.d
    install -d ${D}${sysconfdir}/apparmor.d/unconfined
    # Our startup/init script
    install -m 0755 ${S}/apparmor-profiles/apparmor_parse.sh ${D}${sysconfdir}/apparmor/
    if echo "${MACHINE_IMAGE_NAME}" | grep 'TG3482'; then
       APPARMOR_MACHINE_PROFILE="TG3482PC2-atom"
    fi
    if echo "${MACHINE_IMAGE_NAME}" | grep 'CGM4140COM'; then
       APPARMOR_MACHINE_PROFILE="CGM4140COM"
    fi
    if echo "${MACHINE_IMAGE_NAME}" | grep 'TG4482'; then
       APPARMOR_MACHINE_PROFILE="TG4482PC2-atom"
    fi
    if echo "${MACHINE_IMAGE_NAME}" | grep 'CGM4331COM'; then
       APPARMOR_MACHINE_PROFILE="CGM4331COM"
    fi
    if echo "${MACHINE_IMAGE_NAME}" | grep 'CGA4131COM'; then
       APPARMOR_MACHINE_PROFILE="CGA4131COM"
    fi
    if echo "${MACHINE_IMAGE_NAME}" | grep 'CGM4981COM'; then
       APPARMOR_MACHINE_PROFILE="CGM4981COM"
    fi
    if echo "${MACHINE_IMAGE_NAME}" | grep 'CGA4332COM'; then
       APPARMOR_MACHINE_PROFILE="CGA4332COM"
    fi
    if echo "${MACHINE_IMAGE_NAME}" | grep 'SR203'; then
       APPARMOR_MACHINE_PROFILE="SR203"
    fi
    if echo "${MACHINE_IMAGE_NAME}" | grep 'SR213'; then
       APPARMOR_MACHINE_PROFILE="SR213"
    fi
    if echo "${MACHINE_IMAGE_NAME}" | grep 'WNXL11BWL'; then
       APPARMOR_MACHINE_PROFILE="WNXL11BWL"
    fi
    if echo "${MACHINE_IMAGE_NAME}" | grep 'SCER11BEL'; then
       APPARMOR_MACHINE_PROFILE="SCER11BEL"
    fi
    if echo "${MACHINE_IMAGE_NAME}" | grep 'CVA601ZCOM'; then
       APPARMOR_MACHINE_PROFILE="CVA601ZCOM"
    fi
    if echo "${MACHINE_IMAGE_NAME}" | grep 'VTER11QEL'; then
       APPARMOR_MACHINE_PROFILE="VTER11QEL"
    fi
    if echo "${MACHINE_IMAGE_NAME}" | grep 'CGM601TCOM'; then
       APPARMOR_MACHINE_PROFILE="CGM601TCOM"
    fi
    if echo "${MACHINE_IMAGE_NAME}" | grep 'CWA438TCOM'; then
       APPARMOR_MACHINE_PROFILE="CWA438TCOM"
    fi
    if echo "${MACHINE_IMAGE_NAME}" | grep 'SG417DBCT'; then
       APPARMOR_MACHINE_PROFILE="SG417DBCT"
    fi
    for i in ${S}/apparmor-profiles/RDKB/*; do
        name=$(basename "$i")
        if [  -e "${S}/apparmor-profiles/profiles/broadband/${APPARMOR_MACHINE_PROFILE}/$name" ]; then
             sed -i 's/}//' ${S}/apparmor-profiles/RDKB/$name
             sed -i '1d' ${S}/apparmor-profiles/profiles/broadband/${APPARMOR_MACHINE_PROFILE}/$name
             cat ${S}/apparmor-profiles/RDKB/$name ${S}/apparmor-profiles/profiles/broadband/${APPARMOR_MACHINE_PROFILE}/$name > ${D}${sysconfdir}/apparmor.d/$name
        fi
    done

    for i in ${S}/apparmor-profiles/profiles_unconfined/*; do
        name=$(basename "$i")
        if [  -e "${S}/apparmor-profiles/profiles_unconfined/$name" ]; then
             install -m 0644 ${S}/apparmor-profiles/profiles_unconfined/$name ${D}${sysconfdir}/apparmor.d/unconfined/$name
        fi
    done

    if (! echo "${MACHINE_IMAGE_NAME}" | grep -q 'WNXL11BWL') && (! echo "${MACHINE_IMAGE_NAME}" | grep -q 'SR203') && (! echo "${MACHINE_IMAGE_NAME}" | grep -q 'SR213') && (! echo "${MACHINE_IMAGE_NAME}" | grep -q 'SCER11BEL') && (! echo "${MACHINE_IMAGE_NAME}" | grep -q 'CVA601ZCOM') && (! echo "${MACHINE_IMAGE_NAME}" | grep -q 'CGM601TCOM') && (! echo "${MACHINE_IMAGE_NAME}" | grep -q 'CWA438TCOM') && (! echo "${MACHINE_IMAGE_NAME}" | grep -q 'SG417DBCT'); then
         install -m 0644 ${S}/apparmor-profiles/RDKB/global ${D}${sysconfdir}/apparmor.d/
         install -m 0644 ${S}/apparmor-profiles/RDKB/etc.apparmor.apparmor_parse.sh ${D}${sysconfdir}/apparmor.d/
    fi
         install -m 0644 ${S}/apparmor-profiles/RDKB/usr.bin.interdevicemanager ${D}${sysconfdir}/apparmor.d/
         install -m 0644 ${S}/apparmor-profiles/RDKB/usr.sbin.radiusauthd ${D}${sysconfdir}/apparmor.d/
         install -m 0755 ${S}/apparmor-profiles/RDKB/earlyload_apparmor_profile.sh ${D}${sysconfdir}/apparmor/
         install -m 0644 ${S}/apparmor-profiles/RDKB/usr.ccsp.ovsagent.OvsAgent_ovsdb-server_check.sh ${D}${sysconfdir}/apparmor.d/
    if ( echo "${MACHINE_IMAGE_NAME}" | grep -q 'TG4482') || ( echo "${MACHINE_IMAGE_NAME}" | grep -q 'TG3482'); then
         install -m 0644 ${S}/apparmor-profiles/RDKB/etc.dropbear_js_atom_ipv4.sh ${D}${sysconfdir}/apparmor.d/
    fi
    if ( echo "${MACHINE_IMAGE_NAME}" | grep -q 'CGA4131COM') || ( echo "${MACHINE_IMAGE_NAME}" | grep -q 'CGA4332COM'); then
         install -m 0644 ${S}/apparmor-profiles/RDKB/usr.ccsp.cosa_start.sh ${D}${sysconfdir}/apparmor.d/
         install -m 0644 ${S}/apparmor-profiles/RDKB/usr.ccsp.cosa_start_rem.sh ${D}${sysconfdir}/apparmor.d/
    fi
    install -m 0644 ${S}/apparmor-profiles/default ${D}${sysconfdir}/apparmor/caps/
    install -m 0644 ${S}/apparmor-profiles/global_unconfined_ix ${D}${sysconfdir}/apparmor/unconfined/

    #install -m 0644 ${S}/apparmor-profiles/global_unconfined_pix ${D}${sysconfdir}/apparmor/unconfined/
    install -m 0644 ${S}/apparmor-profiles/global_system_wide ${D}${sysconfdir}/apparmor/
    install -m 0644 ${S}/apparmor-profiles/Apparmor_exclude_systemdservice_broadband.inc ${D}${sysconfdir}/apparmor/Apparmor_exclude_systemdservice.inc

    if [ "${APPARMOR_MACHINE_PROFILE}" = "VTER11QEL" ]; then
         cat ${S}/apparmor-profiles/profiles/broadband/${APPARMOR_MACHINE_PROFILE}/apparmor_defaults >>  ${S}/apparmor-profiles/apparmor_defaults
    fi

    install -m 0644 ${S}/apparmor-profiles/apparmor_defaults  ${D}${sysconfdir}/apparmor/
    install -m 0755 ${S}/apparmor-profiles/aar_telemetry_rdkb.sh   ${D}${sysconfdir}/apparmor/aar_telemetry.sh
    install -m 0644 ${S}/rdk-apparmor-profiles/apparmor.service ${D}${systemd_system_unitdir}/apparmor.service
    install -D -m 0644 ${S}/apparmor-profiles/apparmor.conf ${D}${systemd_system_unitdir}/apparmor.service.d/apparmor.conf
    install -m 0644 ${S}/apparmor-profiles/earlyload-apparmor.service ${D}${systemd_system_unitdir}
}
SYSTEMD_SERVICE_${PN}_append = " earlyload-apparmor.service"
FILES_${PN} += "${sysconfdir}/apparmor/earlyload_apparmor_profile.sh"
FILES_${PN}-optimized = "${sysconfdir}/apparmor/parser.conf \
                         ${sysconfdir}/apparmor/subdomain.conf \
                         ${sysconfdir}/init.d/apparmor \
                         ${base_libdir}/apparmor/functions \
                         ${base_libdir}/apparmor/rc.apparmor.functions \
                         ${bindir}/aa-enabled \
                         ${bindir}/aa-exec"

FILES_${PN}_append = " ${systemd_system_unitdir}/apparmor.service.d/apparmor.conf"
